<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('course_progress', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id');
            $table->foreignId('course_id')->nullable();
            $table->foreignId('chapter_id')->nullable();
            $table->foreignId('lesson_id')->nullable();
            $table->boolean('watched')->default(0);
            $table->boolean('current')->default(0);
            $table->enum('type', ['lesson', 'quiz', 'document', 'live'])->default('lesson');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('course_progress');
    }
};
